/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWPartnerLinkDefinition;
import filenet.vw.api.VWReceiveInstruction;
import filenet.vw.api.VWReplyInstruction;
import filenet.vw.api.VWSchema;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.VWWebServiceUtils;
import filenet.vw.toolkit.design.property.dialog.IVWWebServiceParamPanel;
import filenet.vw.toolkit.design.property.dialog.VWReplyWSOperationParameterPanel;
import filenet.vw.toolkit.design.property.images.VWImageLoader;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.IVWPropertyData;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWExpressionBuilderDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class VWReplyGeneralPanel
extends JPanel
implements DocumentListener,
ActionListener,
IVWPropertyChangeListener,
IVWToolbarBorderActionListener {
    private static final int MODE_BASIC = 0;
    private static final int MODE_ADVANCED = 1;
    private static final int MODE_FAULT = 2;
    private JComboBox m_partnerLinkCombo = null;
    private JComboBox m_operationCombo = null;
    private JRadioButton m_messageRB = null;
    private JRadioButton m_faultRB = null;
    private VWToolbarBorder m_faultBorder = null;
    private JTextField m_faultTextField = null;
    private VWReplyWSOperationParameterPanel m_simplePanel = null;
    private VWToolbarBorder m_outgoingMsgBorder = null;
    private JTextArea m_outgoingMsgTextArea = null;
    private VWToolbarBorder m_schemaBorder = null;
    private JComboBox m_schemaCombo = null;
    private VWToolbarBorder m_elementBorder = null;
    private JComboBox m_elementCombo = null;
    private JButton m_retrieveMessageButton = null;
    private JDialog m_parentDialog = null;
    private Frame m_parentFrame = null;
    private IVWWebServiceParamPanel m_parentWSParamPanel = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWReplyInstruction m_instructionDef = null;
    private Hashtable m_modeHashtable = null;

    public VWReplyGeneralPanel(JDialog parentDialog, IVWWebServiceParamPanel parentPanel, VWAuthPropertyData authPropertyData, int nDisplayMode) {
        this.m_parentDialog = parentDialog;
        this.m_parentWSParamPanel = parentPanel;
        this.m_authPropertyData = authPropertyData;
        this.createControls(nDisplayMode);
    }

    public VWReplyGeneralPanel(Frame parentFrame, IVWWebServiceParamPanel parentPanel, VWAuthPropertyData authPropertyData, int nDisplayMode) {
        this.m_parentFrame = parentFrame;
        this.m_parentWSParamPanel = parentPanel;
        this.m_authPropertyData = authPropertyData;
        this.createControls(nDisplayMode);
    }

    public void setInstructionDefinition(VWReplyInstruction instructionDef) {
        if (instructionDef != null) {
            this.m_instructionDef = instructionDef;
            this.reinitialize();
        }
    }

    public void changedUpdate(DocumentEvent e) {
        Document doc = e.getDocument();
        if (doc == this.m_outgoingMsgTextArea.getDocument()) {
            this.updateOutgoingMsg();
        } else if (doc == this.m_faultTextField.getDocument()) {
            this.updateFaultName();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src.equals(this.m_partnerLinkCombo)) {
            this.performPartnerLinkAction();
        } else if (src.equals(this.m_operationCombo)) {
            this.updateOperation();
        } else if (src.equals(this.m_messageRB)) {
            this.performMessageAction();
        } else if (src.equals(this.m_faultRB)) {
            this.performFaultAction(true);
        } else if (src.equals(this.m_schemaCombo)) {
            this.performSchemaAction();
        } else if (src.equals(this.m_elementCombo)) {
            this.performElementAction();
        } else if (src.equals(this.m_retrieveMessageButton)) {
            this.performRetrieveMessageTemplate();
        }
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        switch (event.getID()) {
            case 526: 
            case 527: 
            case 528: 
            case 529: {
                this.initPartnerLinkComboBox();
                break;
            }
            case 547: 
            case 548: 
            case 549: {
                this.initSchemaComboBox();
            }
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            Object src = event.getSource();
            if (src.equals(this.m_outgoingMsgBorder)) {
                VWExpressionBuilderDialog expressionBuilderDlg = new VWExpressionBuilderDialog(this.m_authPropertyData.getMainContainer(), (IVWPropertyData)this.m_authPropertyData, null, this.m_outgoingMsgTextArea.getText(), 2703);
                expressionBuilderDlg.init();
                expressionBuilderDlg.setVisible(true);
                if (expressionBuilderDlg.getDialogResult() == 0) {
                    String expressionString = expressionBuilderDlg.getExpressionString();
                    this.m_outgoingMsgTextArea.setText(expressionString);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createControls(int nDisplayMode) {
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(5, 5, 0, 5);
            if (nDisplayMode == 0) {
                gbCons.insets = new Insets(0, 0, 0, 20);
            }
            VWToolbarBorder partnerLinkBorder = new VWToolbarBorder(VWResource.s_partnerLink);
            JPanel partnerLinkPanel = partnerLinkBorder.getClientPanel();
            partnerLinkPanel.setLayout(new BorderLayout());
            this.m_partnerLinkCombo = new JComboBox();
            this.m_partnerLinkCombo.setRenderer(new VWLabelListCellRenderer());
            this.m_partnerLinkCombo.addActionListener(this);
            partnerLinkPanel.add(this.m_partnerLinkCombo);
            this.add((Component)partnerLinkBorder, gbCons);
            ++gbCons.gridy;
            gbCons.insets = new Insets(0, 5, 0, 5);
            if (nDisplayMode == 0) {
                gbCons.insets = new Insets(0, 0, 0, 20);
                gbCons.gridheight = 0;
            }
            VWToolbarBorder operationBorder = new VWToolbarBorder(VWResource.s_operation);
            JPanel operationPanel = operationBorder.getClientPanel();
            operationPanel.setLayout(new BorderLayout());
            this.m_operationCombo = new JComboBox();
            this.m_operationCombo.setRenderer(new VWLabelListCellRenderer());
            this.m_operationCombo.addActionListener(this);
            operationPanel.add(this.m_operationCombo);
            this.add((Component)operationBorder, gbCons);
            ++gbCons.gridy;
            gbCons.gridheight = 1;
            if (nDisplayMode == 0) {
                ++gbCons.gridx;
                gbCons.gridy = 0;
            }
            this.add((Component)this.getMessageTypePanel(), gbCons);
            ++gbCons.gridy;
            this.m_faultBorder = new VWToolbarBorder(VWResource.s_faultName);
            this.m_faultBorder.addToolbarBorderActionNotifier(this);
            JPanel faultPanel = this.m_faultBorder.getClientPanel();
            faultPanel.setLayout(new BorderLayout());
            this.m_faultTextField = new JTextField();
            this.m_faultTextField.getDocument().addDocumentListener(this);
            faultPanel.add(this.m_faultTextField);
            this.m_faultBorder.setVisible(false);
            this.add((Component)this.m_faultBorder, gbCons);
            ++gbCons.gridy;
            this.add((Component)this.getAdvancedPanel(), gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            this.m_simplePanel = this.m_parentDialog != null ? new VWReplyWSOperationParameterPanel(this.m_parentDialog, this.m_authPropertyData) : new VWReplyWSOperationParameterPanel(this.m_parentFrame, this.m_authPropertyData);
            this.add((Component)this.m_simplePanel, gbCons);
            ++gbCons.gridy;
            this.m_outgoingMsgBorder = new VWToolbarBorder(VWResource.s_outgoingMessage, 32);
            this.m_outgoingMsgBorder.addToolbarBorderActionNotifier(this);
            JPanel outgoingMsgPanel = this.m_outgoingMsgBorder.getClientPanel();
            outgoingMsgPanel.setLayout(new BorderLayout());
            this.m_outgoingMsgTextArea = new JTextArea();
            this.m_outgoingMsgTextArea.setTabSize(4);
            this.m_outgoingMsgTextArea.getDocument().addDocumentListener(this);
            outgoingMsgPanel.add(new JScrollPane(this.m_outgoingMsgTextArea));
            this.add((Component)this.m_outgoingMsgBorder, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.m_authPropertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
    }

    private JPanel getAdvancedPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.anchor = 23;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.fill = 2;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(5, 0, 2, 5);
        this.m_schemaBorder = new VWToolbarBorder(VWResource.s_schema);
        JPanel schemaPanel = this.m_schemaBorder.getClientPanel();
        schemaPanel.setLayout(new BorderLayout());
        this.m_schemaCombo = new JComboBox();
        this.m_schemaCombo.setRenderer(new VWLabelListCellRenderer());
        this.m_schemaCombo.addActionListener(this);
        schemaPanel.add(this.m_schemaCombo);
        panel.add((Component)this.m_schemaBorder, gbCons);
        ++gbCons.gridx;
        gbCons.fill = 0;
        gbCons.weightx = 0.0;
        gbCons.insets = new Insets(5, 0, 2, 0);
        this.m_retrieveMessageButton = VWImageLoader.createIconButton("create_message.gif", VWResource.s_createMessageTemplate);
        this.m_retrieveMessageButton.addActionListener(this);
        panel.add((Component)this.m_retrieveMessageButton, gbCons);
        gbCons.gridx = 0;
        ++gbCons.gridy;
        gbCons.fill = 2;
        gbCons.weightx = 1.0;
        gbCons.insets = new Insets(0, 0, 2, 5);
        this.m_elementBorder = new VWToolbarBorder(VWResource.s_element);
        JPanel elementPanel = this.m_elementBorder.getClientPanel();
        elementPanel.setLayout(new BorderLayout());
        this.m_elementCombo = new JComboBox();
        this.m_elementCombo.setRenderer(new VWLabelListCellRenderer());
        this.m_elementCombo.addActionListener(this);
        this.m_elementCombo.setEditable(true);
        elementPanel.add((Component)this.m_elementCombo, "Center");
        panel.add((Component)this.m_elementBorder, gbCons);
        return panel;
    }

    private JPanel getMessageTypePanel() {
        VWToolbarBorder messageTypeBorder = new VWToolbarBorder(VWResource.s_messageType);
        JPanel msgTypePanel = messageTypeBorder.getClientPanel();
        msgTypePanel.setLayout(new GridLayout(1, 2));
        this.m_messageRB = new JRadioButton(VWResource.s_message);
        this.m_messageRB.setSelected(true);
        this.m_messageRB.addActionListener(this);
        msgTypePanel.add(this.m_messageRB);
        this.m_faultRB = new JRadioButton(VWResource.s_fault);
        this.m_faultRB.setSelected(false);
        this.m_faultRB.addActionListener(this);
        msgTypePanel.add(this.m_faultRB);
        ButtonGroup buttonGrp = new ButtonGroup();
        buttonGrp.add(this.m_messageRB);
        buttonGrp.add(this.m_faultRB);
        return messageTypeBorder;
    }

    private void reinitialize() {
        try {
            if (this.m_instructionDef != null) {
                this.initPartnerLinkComboBox();
                this.updateControlsUsingOperation((String)this.m_operationCombo.getSelectedItem(), false);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateControlsUsingOperation(String operationName, boolean bSwitchClean) {
        switch (this.getMode(operationName)) {
            case 0: {
                this.m_messageRB.removeActionListener(this);
                this.m_messageRB.setSelected(true);
                this.performSimpleAction(bSwitchClean);
                this.m_messageRB.addActionListener(this);
                this.setMode(0, bSwitchClean);
                break;
            }
            case 1: {
                this.m_messageRB.removeActionListener(this);
                this.m_messageRB.setSelected(true);
                this.performAdvancedAction(bSwitchClean);
                this.m_messageRB.addActionListener(this);
                this.setMode(1, bSwitchClean);
                break;
            }
            case 2: {
                this.m_faultRB.removeActionListener(this);
                this.m_faultRB.setSelected(true);
                this.performFaultAction(bSwitchClean);
                this.m_faultRB.addActionListener(this);
                this.setMode(2, bSwitchClean);
            }
        }
    }

    private void initPartnerLinkComboBox() {
        this.m_partnerLinkCombo.removeActionListener(this);
        this.m_partnerLinkCombo.removeAllItems();
        this.m_partnerLinkCombo.addItem(VWResource.s_noneItemStr);
        if (this.m_instructionDef != null && this.m_authPropertyData != null) {
            boolean bFound = false;
            String partnerLinkName = this.m_instructionDef.getPartnerLinkName();
            try {
                VWPartnerLinkDefinition[] partnerLinks = this.m_authPropertyData.getPartnerLinks();
                if (partnerLinks != null && partnerLinks.length > 0) {
                    Vector<String> nameVector = new Vector<String>();
                    for (int i = 0; i < partnerLinks.length; ++i) {
                        if (partnerLinks[i].getMyPortType() == null) continue;
                        nameVector.addElement(partnerLinks[i].getName());
                    }
                    Object[] partnerLinkNames = null;
                    if (nameVector.size() > 0) {
                        partnerLinkNames = new String[nameVector.size()];
                        nameVector.copyInto(partnerLinkNames);
                        nameVector.removeAllElements();
                        nameVector = null;
                    }
                    if (partnerLinkNames != null) {
                        VWQubbleSort.sort(partnerLinkNames);
                        for (int i = 0; i < partnerLinkNames.length; ++i) {
                            this.m_partnerLinkCombo.addItem(partnerLinkNames[i]);
                            if (bFound || partnerLinkName == null) continue;
                            bFound = partnerLinkName.compareTo((String)partnerLinkNames[i]) == 0;
                        }
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
            if (partnerLinkName != null && partnerLinkName.length() > 0) {
                if (!bFound) {
                    this.m_partnerLinkCombo.addItem(partnerLinkName);
                }
                this.m_partnerLinkCombo.setSelectedItem(partnerLinkName);
            } else {
                this.m_partnerLinkCombo.setSelectedIndex(0);
            }
        }
        this.m_partnerLinkCombo.addActionListener(this);
        this.setOperationAccordingToPartnerLink();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOperationAccordingToPartnerLink() {
        int nIndex = 0;
        try {
            String curPartnerLinkName;
            this.m_operationCombo.removeActionListener(this);
            this.m_operationCombo.removeAllItems();
            this.m_operationCombo.addItem(VWResource.s_noneItemStr);
            if (this.m_modeHashtable == null) {
                this.m_modeHashtable = new Hashtable();
            } else {
                this.m_modeHashtable.clear();
            }
            if (this.m_instructionDef != null && this.m_authPropertyData != null && (curPartnerLinkName = this.m_instructionDef.getPartnerLinkName()) != null && curPartnerLinkName.length() > 0) {
                VWPartnerLinkDefinition curPartnerLink = null;
                VWPartnerLinkDefinition[] partnerLinks = this.m_authPropertyData.getPartnerLinks();
                if (partnerLinks != null && partnerLinks.length > 0) {
                    for (int i = 0; i < partnerLinks.length; ++i) {
                        if (VWStringUtils.compare(partnerLinks[i].getName(), curPartnerLinkName) != 0) continue;
                        curPartnerLink = partnerLinks[i];
                        break;
                    }
                    if (curPartnerLink != null) {
                        String curOperationName = this.m_instructionDef.getOperationName();
                        Vector receiveInstRefs = curPartnerLink.getReceiveInstructionRefs();
                        if (receiveInstRefs != null && receiveInstRefs.size() > 0) {
                            int i;
                            Object[] operationNames = new String[receiveInstRefs.size()];
                            for (i = 0; i < receiveInstRefs.size(); ++i) {
                                VWReceiveInstruction receiveInst = (VWReceiveInstruction)receiveInstRefs.elementAt(i);
                                operationNames[i] = receiveInst.getOperationName();
                                if (operationNames[i] == null || ((String)operationNames[i]).length() <= 0) continue;
                                Boolean bAdvanced = receiveInst.getMessageExpr() != null;
                                this.m_modeHashtable.put(operationNames[i], bAdvanced);
                            }
                            VWQubbleSort.sort(operationNames);
                            for (i = 0; i < operationNames.length; ++i) {
                                if (operationNames[i] == null || ((String)operationNames[i]).length() <= 0) continue;
                                this.m_operationCombo.addItem(operationNames[i]);
                                if (VWStringUtils.compare((String)operationNames[i], curOperationName) != 0) continue;
                                nIndex = i + 1;
                            }
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        try {
            this.m_operationCombo.setSelectedIndex(nIndex);
            String newOperation = (String)this.m_operationCombo.getSelectedItem();
            if (newOperation.equals(VWResource.s_noneItemStr)) {
                newOperation = null;
            }
            if (this.m_instructionDef != null) {
                this.m_instructionDef.setOperationName(newOperation);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            this.m_operationCombo.addActionListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSchemaComboBox() {
        DefaultComboBoxModel<String> cbModel = new DefaultComboBoxModel<String>();
        cbModel.addElement(VWResource.s_noneItemStr);
        int nSchemaIndex = 0;
        try {
            Object[] schemas;
            if (this.m_instructionDef != null && this.m_authPropertyData != null && (schemas = this.m_authPropertyData.getSchemas()) != null && schemas.length > 0) {
                VWQubbleSort.sort(schemas);
                String schemaName = this.m_instructionDef.getMessageFromSchemaName();
                for (int i = 0; i < schemas.length; ++i) {
                    Object schema = schemas[i];
                    String name = ((VWSchema)schema).getName();
                    if (schemaName != null && VWStringUtils.compare(name, schemaName) == 0) {
                        nSchemaIndex = i + 1;
                    }
                    cbModel.addElement(name);
                }
                if (schemaName != null && nSchemaIndex == 0) {
                    cbModel.addElement(schemaName);
                    nSchemaIndex = cbModel.getSize() - 1;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            this.m_schemaCombo.removeActionListener(this);
            this.m_schemaCombo.setModel(cbModel);
            this.m_schemaCombo.setSelectedIndex(nSchemaIndex);
            this.m_schemaCombo.addActionListener(this);
            this.initElementComboBox(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initElementComboBox(boolean bAddSetting) {
        DefaultComboBoxModel<String> cbModel = new DefaultComboBoxModel<String>();
        int nElementIndex = 0;
        try {
            VWSchema vwSchema;
            String schemaName;
            cbModel.addElement(VWResource.s_noneItemStr);
            if (this.m_authPropertyData != null && this.m_instructionDef != null && (schemaName = this.m_instructionDef.getMessageFromSchemaName()) != null && (vwSchema = this.m_authPropertyData.getSchema(schemaName)) != null) {
                String[] elementNames;
                String schema;
                String elementName = this.m_instructionDef.getMessageFromElementName();
                VWWebServiceUtils wsUtils = this.m_authPropertyData.getWebServiceUtils();
                if (wsUtils != null && (schema = vwSchema.getSchema()) != null && schema.length() > 0 && (elementNames = wsUtils.getElementNamesFromSchema(schema)) != null && elementNames.length > 0) {
                    for (int i = 0; i < elementNames.length; ++i) {
                        if (elementName != null && VWStringUtils.compare(elementNames[i], elementName) == 0) {
                            nElementIndex = i + 1;
                        }
                        cbModel.addElement(elementNames[i]);
                    }
                }
                if (bAddSetting && elementName != null && nElementIndex == 0) {
                    cbModel.addElement(elementName);
                    nElementIndex = cbModel.getSize() - 1;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            if (this.m_authPropertyData != null && !bAddSetting) {
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_errorRetrievingSchemaElements, 1);
            }
        }
        finally {
            this.m_elementCombo.removeActionListener(this);
            this.m_elementCombo.setModel(cbModel);
            this.m_elementCombo.setSelectedIndex(nElementIndex);
            this.m_elementCombo.addActionListener(this);
        }
    }

    private void performPartnerLinkAction() {
        try {
            String partnerLink = (String)this.m_partnerLinkCombo.getSelectedItem();
            if (partnerLink.compareTo(VWResource.s_noneItemStr) == 0) {
                partnerLink = null;
            }
            if (this.m_instructionDef != null && this.m_authPropertyData != null) {
                this.m_instructionDef.setPartnerLinkName(partnerLink);
                this.m_authPropertyData.setDirty();
            }
            this.setOperationAccordingToPartnerLink();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateOutgoingMsg() {
        try {
            if (this.m_instructionDef != null && this.m_authPropertyData != null) {
                String inputMsg = this.m_outgoingMsgTextArea.getText();
                if (inputMsg != null && inputMsg.length() > 0) {
                    this.m_instructionDef.setMessageExpr(inputMsg);
                } else {
                    this.m_instructionDef.setMessageExpr(null);
                }
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performMessageAction() {
        try {
            if (this.m_instructionDef != null && this.m_authPropertyData != null) {
                this.m_instructionDef.setFaultName(null);
                this.m_instructionDef.setMessageExpr(null);
            }
            String operationName = (String)this.m_operationCombo.getSelectedItem();
            switch (this.getMode(operationName)) {
                case 0: {
                    this.performSimpleAction(true);
                    break;
                }
                case 1: {
                    this.performAdvancedAction(true);
                    break;
                }
                default: {
                    VWDebug.logError("VWReplyGeneralPanel::performMessageAction() - invalid state.");
                    break;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performSimpleAction(boolean bSwitchClean) {
        try {
            this.m_faultBorder.setVisible(false);
            this.m_simplePanel.setVisible(true);
            this.m_outgoingMsgBorder.setVisible(false);
            this.m_schemaBorder.setVisible(false);
            this.m_elementBorder.setVisible(false);
            this.m_retrieveMessageButton.setVisible(false);
            if (bSwitchClean) {
                this.setMode(0, true);
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performAdvancedAction(boolean bSwitchClean) {
        try {
            this.m_faultBorder.setVisible(false);
            this.m_simplePanel.setVisible(false);
            this.m_outgoingMsgBorder.setVisible(true);
            this.m_schemaBorder.setVisible(true);
            this.m_elementBorder.setVisible(true);
            this.m_retrieveMessageButton.setVisible(true);
            if (bSwitchClean) {
                this.setMode(1, true);
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performFaultAction(boolean bSwitchClean) {
        try {
            this.m_faultBorder.setVisible(true);
            this.m_simplePanel.setVisible(false);
            this.m_outgoingMsgBorder.setVisible(true);
            this.m_schemaBorder.setVisible(false);
            this.m_elementBorder.setVisible(false);
            this.m_retrieveMessageButton.setVisible(false);
            if (bSwitchClean) {
                this.setMode(2, true);
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performSchemaAction() {
        try {
            String schema;
            if (this.m_instructionDef != null && this.m_authPropertyData != null && (schema = (String)this.m_schemaCombo.getSelectedItem()) != null) {
                if (VWStringUtils.compare(schema, VWResource.s_noneItemStr) == 0) {
                    schema = null;
                }
                this.m_instructionDef.setMessageFromSchemaName(schema);
                this.initElementComboBox(false);
                if (this.m_parentWSParamPanel != null) {
                    this.m_parentWSParamPanel.reinitializeCorrelationParamList();
                }
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performElementAction() {
        try {
            String element;
            if (this.m_instructionDef != null && this.m_authPropertyData != null && (element = (String)this.m_elementCombo.getSelectedItem()) != null) {
                if (VWStringUtils.compare(element, VWResource.s_noneItemStr) == 0) {
                    element = null;
                }
                this.m_instructionDef.setMessageFromElementName(element);
                if (this.m_parentWSParamPanel != null) {
                    this.m_parentWSParamPanel.reinitializeCorrelationParamList();
                }
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performRetrieveMessageTemplate() {
        String schemaFieldName = null;
        String elementName = null;
        String schema = null;
        String messageTemplate = null;
        try {
            VWSchema vwSchema;
            if (this.m_instructionDef != null) {
                schemaFieldName = this.m_instructionDef.getMessageFromSchemaName();
                elementName = this.m_instructionDef.getMessageFromElementName();
            }
            if (schemaFieldName != null && schemaFieldName.length() > 0 && this.m_authPropertyData != null && (vwSchema = this.m_authPropertyData.getSchema(schemaFieldName)) != null) {
                schema = vwSchema.getSchema();
            }
            if (this.m_authPropertyData != null) {
                VWWebServiceUtils wsUtils = this.m_authPropertyData.getWebServiceUtils();
                if (wsUtils != null && schema != null && schema.length() > 0 && elementName != null && elementName.length() > 0) {
                    messageTemplate = wsUtils.getExpressionTemplate(schemaFieldName, schema, elementName);
                } else {
                    VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), VWResource.s_unableToRetrieveSampleMessage, 2);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            String message = ex.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = VWResource.s_errorRetrievingMessageTemplate;
            }
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), message, 1);
        }
        this.m_outgoingMsgTextArea.setText(messageTemplate);
    }

    private void updateOperation() {
        try {
            if (this.m_instructionDef != null && this.m_authPropertyData != null) {
                String operationName = (String)this.m_operationCombo.getSelectedItem();
                if (operationName != null && operationName.equals(VWResource.s_noneItemStr)) {
                    operationName = null;
                } else {
                    this.updateControlsUsingOperation(operationName, true);
                }
                this.m_instructionDef.setOperationName(operationName);
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateFaultName() {
        try {
            if (this.m_instructionDef != null && this.m_authPropertyData != null) {
                this.m_instructionDef.setFaultName(this.m_faultTextField.getText());
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private int getMode(String operationName) {
        int nMode = 0;
        try {
            if (this.m_instructionDef != null) {
                String faultName = this.m_instructionDef.getFaultName();
                String outgoingMsg = this.m_instructionDef.getMessageExpr();
                String schema = this.m_instructionDef.getMessageFromSchemaName();
                String element = this.m_instructionDef.getMessageFromElementName();
                boolean bAdvanced = false;
                if (this.m_modeHashtable != null && operationName != null && this.m_modeHashtable.containsKey(operationName)) {
                    Boolean bAdvancedOperation = (Boolean)this.m_modeHashtable.get(operationName);
                    bAdvanced = bAdvancedOperation;
                }
                nMode = faultName != null ? 2 : (bAdvanced || outgoingMsg != null && schema != null && element != null ? 1 : 0);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return nMode;
    }

    private void setMode(int nMode, boolean bInitialValue) {
        try {
            switch (nMode) {
                case 0: {
                    if (this.m_instructionDef != null) {
                        this.m_instructionDef.setMessageExpr(null);
                        this.m_instructionDef.setMessageFromSchemaName(null);
                        this.m_instructionDef.setMessageFromElementName(null);
                        this.m_instructionDef.setFaultName(null);
                        this.m_instructionDef.setCorrelationSetName(null);
                        this.m_instructionDef.setCorrelationSetProperties(null);
                    }
                    this.m_simplePanel.reinitialize(this.m_instructionDef);
                    this.m_parentWSParamPanel.switchCSPanelBasicMode();
                    break;
                }
                case 1: {
                    if (this.m_instructionDef != null) {
                        this.m_instructionDef.deleteAllParameters();
                        this.m_instructionDef.setFaultName(null);
                        if (bInitialValue) {
                            this.m_instructionDef.setMessageExpr(null);
                            this.m_instructionDef.setMessageFromSchemaName(null);
                            this.m_instructionDef.setMessageFromElementName(null);
                        }
                        this.m_outgoingMsgTextArea.getDocument().removeDocumentListener(this);
                        this.m_outgoingMsgTextArea.setText(this.m_instructionDef.getMessageExpr());
                        this.m_outgoingMsgTextArea.getDocument().addDocumentListener(this);
                    }
                    this.initSchemaComboBox();
                    if (this.m_parentWSParamPanel == null) break;
                    this.m_parentWSParamPanel.reinitializeCorrelationParamList();
                    this.m_parentWSParamPanel.switchCSPanelAdvancedMode();
                    break;
                }
                case 2: {
                    if (this.m_instructionDef != null) {
                        this.m_instructionDef.deleteAllParameters();
                        if (bInitialValue) {
                            this.m_instructionDef.setFaultName(null);
                            this.m_instructionDef.setMessageExpr(null);
                            this.m_instructionDef.setMessageFromSchemaName(null);
                            this.m_instructionDef.setMessageFromElementName(null);
                        }
                        this.m_faultTextField.getDocument().removeDocumentListener(this);
                        this.m_faultTextField.setText(this.m_instructionDef.getFaultName());
                        this.m_faultTextField.getDocument().addDocumentListener(this);
                        this.m_outgoingMsgTextArea.getDocument().removeDocumentListener(this);
                        this.m_outgoingMsgTextArea.setText(this.m_instructionDef.getMessageExpr());
                        this.m_outgoingMsgTextArea.getDocument().addDocumentListener(this);
                    }
                    this.m_parentWSParamPanel.switchCSPanelBasicMode();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

